import sys
from os import environ,getcwd
import string

projectpath=PROJECTPATH
outpath=OUTPATH
simid=SIMID
savefreq=SAVEFREQ

sys.path.append(environ["PYTHON_MODULE_PATH"])
sys.path.append(projectpath+"/src/")

import CompuCellSetup
sim,simthread = CompuCellSetup.getCoreSimulationObjects()
CompuCellSetup.initializeSimulationObjects(sim,simthread)

#Add Python steppables here
steppableRegistry=CompuCellSetup.getSteppableRegistry()

from RandomFieldInitializer import RandomFieldInitializer
initializer=RandomFieldInitializer(sim,175,2,10,border=True,borderType=1,offset=90)
steppableRegistry.registerSteppable(initializer)

from SaveCellField import SaveCellField
saver=SaveCellField(sim,simid,outpath+'/',fieldname="morph",_frequency=savefreq)
steppableRegistry.registerSteppable(saver)

CompuCellSetup.mainLoop(sim,simthread,steppableRegistry)