from PySteppables import *
import numpy as np
import os
import CompuCell

class SaveCellField(SteppableBasePy):
    def __init__(self,_simulator,basename,path,fieldname=None,fieldfreq=None,_frequency=10):
        SteppableBasePy.__init__(self,_simulator,_frequency)
        print '====== Initialize SaveCellField   ====='
        # first part of filename
        self.basename = basename
        # path to save data to
        self.path = path
        if not os.path.isdir(path):
            os.mkdir(path)
        # copy settings for fields
        self.fieldname = fieldname
        if fieldfreq is None:
            self.fieldfreq = _frequency
        else:
            self.fieldfreq = fieldfreq
        print self.fieldname,self.fieldfreq

    def step(self,mcs):
        # empty arrays for cell id's (cf) and types (tf)
        cf = np.zeros((self.dim.x,self.dim.y))
        tf = np.zeros_like(cf)
        chem = None
        if (self.fieldname is not None) and (mcs%self.fieldfreq == 0):
            chemfield=CompuCell.getConcentrationField(self.simulator,self.fieldname)
            chem = np.zeros_like(cf)
        # iterate over CPM grid
        for y in range(self.dim.y):
            for x in range(self.dim.x):
                # retrieve cell at position x,y
                # returns cell object if there is a cell, otherwise it return None
                c = self.cellField.get(x,y,0)
                # if there is a cell, write id and type to arrays
                if c is not None:
                    cf[x,y] = int(c.id)
                    tf[x,y] = int(c.type)
                if chem is not None:
                    chem[x,y] = chemfield.get(x,y,0)
        # save data in a text file
        np.savetxt(self.path+'/'+self.basename+'_CF_'+str(mcs)+'.data',cf)
        np.savetxt(self.path+'/'+self.basename+'_TF_'+str(mcs)+'.data',tf)
        
        if chem is not None:
            np.savetxt(self.path+'/'+self.basename+'_'+str(self.fieldname)+'_'+str(mcs)+'.data',chem)