from random import randint
from PySteppables import *
from CompuCell import Point3D

class RandomFieldInitializer(SteppableBasePy):
    def __init__(self,_simulator,ncells,celltype,growsteps,border=False,borderType=1,offset=0):
        SteppableBasePy.__init__(self,_simulator,10)
        print '===== Initialize RandomFieldInitializer ====='
        self.ncells = ncells
        self.celltype = celltype
        self.border = border
        self.borderType = borderType
        self.growsteps = growsteps
        self.offset = offset
    
    # Grow via Eden-growth algorithm
    def growStep(self):
        nx = [-1, 1, 0, 0]
        ny = [0, 0, -1, 1]        
        growpoints = {}
        for y in range(self.dim.y):
            for x in range(self.dim.x):
                pt = Point3D(x,y,0)
                if self.cellField.get(x,y,0) is None:
                    r = randint(0,len(nx)-1)
                    npt = Point3D(x+nx[r],y+ny[r],0)
                    if self.cellField.get(npt):
                        growpoints[pt] = self.cellField.get(npt)
        return growpoints
    
    def addBorderCell(self):
        print 'add Border cell'
        cell = self.potts.createCellG(Point3D(0,0,0))
        cell.type = self.borderType
        for x in range(self.dim.x):
            self.cellField.set(Point3D(x,0,0),cell)
            self.cellField.set(Point3D(x,self.dim.y-1,0),cell)
        for y in range(self.dim.y):
            self.cellField.set(Point3D(0,y,0),cell)
            self.cellField.set(Point3D(self.dim.x-1,y,0),cell)
        self.potts.runSteppers()

    def start(self):
        # initialize all cells as a single pixel
        print 'add cells'
        (xmin,xmax) = (self.offset,self.dim.x-self.offset)
        (ymin,ymax) = (self.offset,self.dim.y-self.offset)        
        for i in range(self.ncells):
            placed = False
            while not placed:
                pt = Point3D(randint(xmin,xmax-1),randint(ymin,ymax-1),0)
                if self.cellField.get(pt) is None:
                    placed = True
                    cell = self.potts.createCellG(pt)
                    cell.type = self.celltype
                    self.potts.runSteppers()
        # grow cells
        for n in range(self.growsteps):
            print 'growstep '+str(n)
            self.growStep()
            growpoints = self.growStep()
            for point,cell in growpoints.iteritems():
                self.cellField.set(point,cell)            
            self.potts.runSteppers()
        # add border cell
        if self.border:
            self.addBorderCell()
            self.potts.runSteppers()