import string,sys
sys.path.append('src/')
from CC3DSimUtils import createPBSScripts

#--- General settings ---#
# list of simulation numbers
numlist = range(1,11)
# list of simulation repeats
replist = range(1,11)
# simulation names included in the parameter study
simnames = ['longcells_chem','longcells_nochem']
# identified for all simulations
basename = 'longcells'

#--- Cluster settings ---#
# number of cores in requested node
cores = 8
# number of tasks on one node
ppn = 8
# requested time
runtime = '12:00:00'

#--- create pbs scripts for simulations ---#
runid = basename+'_'+str(numlist[0])+'-'+str(numlist[-1])+'_'+str(len(replist))+'x'
joblist = [name+'_'+string.zfill(num,3)+'-'+str(n) for name in simnames for num in numlist for n in replist]
createPBSScripts(runid,joblist,'python driver.py',runtime,cores,ppn,path='clusterscripts/')
