import os,random,string,sys
import xml.dom.minidom as xdm
import numpy as np
sys.path.append('src/')
from CC3DSimUtils import Experiment

# Create a cc3d file for one simulation
# Parameters:
#   simname: name of the simulation
#   path: path where the cc3d file will be stored
def buildCC3DScript(simname,path):
    f = open(path+simname+'.cc3d','w')
    f.write('<Simulation version="3.6.1">\n')
    f.write('\t<XMLScript Type="XMLScript">'+simname+'/'+simname+'.xml</XMLScript>\n')
    f.write('\t<PythonScript Type="PythonScript">'+simname+'/'+simname+'.py</PythonScript>\n')
    f.write('</Simulation>')
    f.close()

# Create a python script for one simulation by authomatically 
# changing a number of statements in a template python script.
# Parameters:
#   - simname: name of the simulation
#   - scriptpath: path where the cc3d files are stored
#   - projectpath: path to the project directory
#   - datapath: path where the data generated during the simulaiton will be stored
#   - freq: frequency at which simulation data is saved
#   - template: path to python file that serves as the template
def buildPyScript(simname,scriptpath,projectpath,datapath,freq,template):
    f = open(template)
    o = open(scriptpath+'/'+simname+'/'+simname+'.py','w')
    for line in f.readlines():
        if line.startswith('projectpath'):
            o.write('projectpath="'+projectpath+'"\n')
        elif line.startswith('simid='):
            o.write('simid="'+simname+'"\n')
        elif line.startswith('savefreq='):
            o.write('savefreq='+str(freq)+'\n')
        elif line.startswith('outpath='):
            o.write('outpath="'+datapath+'"\n')
        else:
            o.write(line)
    f.close()
    o.close()

#--- General settings ---#
# path definitions
projectpath = os.getcwd()
templatepath = 'templates/'
scriptpath = 'scripts/'
datapath = projectpath+'/data/'
# simulation names included in the parameter study
simnames = ['longcells_chem','longcells_nochem']
# simulation number of the first simulation
offset = 1
# number of simulation repeats
repeats = 10
# number of the first simulation repeat
rep0 = 1
# number of simulation steps
MCS = 100000
# save frequency
savefreq = 250
# list of surface tensions: st = Jcm - 0.5*Jcc -> Jcm = st+0.5*Jcc
Jcc = 0.5
par = np.arange(-0.05,.63,0.075)
# list of used seeds
seeds = []

#--- Create simulation data file ---#
runid = 'longcells_'+str(offset)+'-'+str(offset+len(par)-1)
# open log file for parameter values
out = open('log/'+runid+'.sim','w')
out.write('#id\tST\tJcc\tJcm')
# open log file for random seeds
sout = open('log/'+runid+'_'+str(repeats)+'x''.seed','w')
sout.write('#id\tseed')
# create all simulation files
for name in simnames:
    for i,st in enumerate(par):
        out.write('\n'+name+'_'+string.zfill(i+offset,3)+'\t'+str(st)+'\t'+str(Jcc)+'\t'+str(Jcm))
        for n in range(rep0,repeats+rep0):
            simid = name+'_'+string.zfill(i+offset,3)+'-'+str(n)
            seed = random.randint(1,10**9)
            # check if seed is unique
            while seed in seeds:
                seed = random.randint(1,10**9)
            seeds.append(seed)
            sout.write('\n'+simid+'\t'+str(seed))
            #--- Create CC3DML ---#
            Jcm = st+0.5*Jcc                        
            e = Experiment(templatepath+name+'.xml')
            e.setMCS(MCS)
            e.setSeed(seed)
            e.setContact('cell','Medium',Jcm)
            if not os.path.isdir(scriptpath+simid):
                os.mkdir(scriptpath+simid)            
            e.write(scriptpath+simid+'/'+simid+'.xml')    
            #--- create python script ---#
            buildPyScript(simid,scriptpath,projectpath,datapath+'/'+simid+'/',savefreq,templatepath+name+'.py')
            #--- create cc3d file ---#
            buildCC3DScript(simid,scriptpath)
out.close()
sout.close()