import numpy as np

# Calculate mean and standard devaition for multiple data sets.
# This script uses the 'naive algorithm' for the variance to calculate 
# both mean and standard deviation in a single pass.
# see: http://en.wikipedia.org/wiki/Algorithms_for_calculating_variance#Na.C3.AFve_algorithm
def getMeanSTDforParSet(simid,repeats,radii):
    # ignore time steps in first column
    cols = [i+1 for i in range(len(radii))]
    s = None
    ss = None
    # calculate running sum and running squared sum
    for n in repeats:
        id = simid+'-'+str(n)
        data = np.loadtxt('data/'+id+'/'+id+'_orderparameter.data',usecols=cols)
        if s is None:
            s = np.zeros_like(data)
            ss = np.zeros_like(data)
        s += data
        ss += np.power(data,2)
    n = float(len(repeats))
    mean = s/n
    std = np.sqrt((ss - (np.power(s,2)/n))/n)
    return (mean,std)

#--- setttings ---#
# path where data files are located, e.g. longcells_nochem_CF_0.data
datapath = 'data/'
# names of the simulations
simnames = ['longcells_nochem','longcells_chem']
# list of repeat numbers
repeats = range(1,11)
# simulation number to analyze
num = '003'
# list of radii for which the order parameter will be calculated
radii = [20,40,600]

# create postfix for data files
postfix = num+'_'+str(len(repeats))+'x_orderparameter.data'
for name in simnames:
    simid = name+'_'+num
    # open file to save order parameters for all simulation with name=name
    f = open('results/'+name+'_'+postfix,'w')
    # write header for each column
    f.write('time\t'+'\t'.join(['r='+str(r)+'\t+/-' for r in radii])+'\n')
    # read time from the first file
    time = np.loadtxt('data/'+simid+'-'+str(repeats[0])+'/'+simid+'-'+str(repeats[0])+'_orderparameter.data',usecols=(0,))
    # create numpy array to save the data
    # we choose numpy arrays because it is really easy to read
    # and save tabular data with numpy
    op = np.zeros((len(time),1+len(radii)*2))
    op[:,0] = time
    (mean,std) = getMeanSTDforParSet(simid,repeats,radii)
    for i in range(len(radii)):
        op[:,2*i+1] = mean[:,i]
        op[:,2*i+2] = std[:,i]
    np.savetxt(f,op)
    f.close()
