import string,sys
import numpy as np
sys.path.append('src/')
from CC3DSimUtils import morphImages

# function to get full path to image based on simulation id, time step and image path
imfile = lambda id,t,impath: impath+'/'+id+'/'+id+'_'+string.zfill(t,5)+'.png'

#--- setttings ---#
# path to the existing images
impath = 'images/'
# names of the simulations
simnames = ['longcells_nochem','longcells_chem']
# parameter values and name
par = np.arange(-0.05,.63,0.075)
parname = 'surface tension'
# use images from simulation repeat 1
repnum = 1
# use every second parameter value
numrange = range(1,11,2)
# use images generated at time step 25000
t = 25000

# create 2D array with image file names
images = [[imfile(name+'_'+string.zfill(i,3)+'-'+str(repnum),t,impath) for i in numrange] for name in simnames]

# create text on x and y axes of the morphospace
xtics = [str(par[i-1]) for i in numrange]
ytics = ['no chemotaxis','chemotaxis']

# create morphospace
morphImages(images,'results/morphospace.png',xlabel=parname,xtics=xtics,ytics=ytics,fontsize=110,border=False)