import string
import numpy as np

#--- setttings ---#
# path where data files are located, e.g. longcells_nochem_CF_0.data
datapath = 'data/'
# names of the simulations
simnames = ['longcells_nochem','longcells_chem']
# list of repeat numbers
repeats = range(1,11)
# list op simulation numbers
numlist = range(1,11)
# parameter values and name
par = np.arange(-0.05,.63,0.075)
parname = 'surface tension'
# use compactness calculated at 100000 time steps
t = 100000

# create postfix for data files
postfix = str(numlist[0])+'-'+str(numlist[-1])+'_'+str(len(repeats))+'x_compactness.data'
# collect mean and standard deviation for the simulation with and without chemotaxis.
for name in simnames:
    comp = np.zeros((len(par),3))
    # open file to save compactness for all simulation with name=name
    f = open('results/'+name+'_'+postfix,'w')
    f.write(parname+'\tcompactness\tstd\n')    
    # collect compactness at t=t for all repeats for each parameter set
    for j,p in enumerate(par):
        simid = name+'_'+string.zfill(j+1,3)
        val = []
        for n in repeats:
            id = simid+'-'+str(n)
            data = np.loadtxt('data/'+id+'/'+id+'_compactness.data')
            # take care of data files with one line
            # numpy will read those into a 1-D array
            if len(data.shape) == 1:
                data = np.reshape(data,(1,data.shape[0]))
            # add compactness at t=t to list
            val.append(data[np.where(data[:,0]==t)[0],1][0])
        # calculate mean and std of compactness
        comp[j,:] = [p,np.mean(val),np.std(val)]
    # save mean and std of compactness to file
    np.savetxt(f,comp)
    f.close()