import sys
sys.path.append('src/')
from CC3DSimUtils import getOrderParameterForSim

# simname will be used as the basis of filenames data files and the generated images. 
simname = 'longcells_chem'
# path where data files are located, e.g. longcells_nochem_CF_0.data
datapath = 'data/'+simname+'/'
# path where results will be stored
outpath = 'results/'
# list of time steps for which the order parameter will be calculated
trange = range(0,10001,250)
# list of radii for which the order parameter will be calculated
radii = [20,40,600]

# calculate order paramter using the calcOrderParameter function in SimUtils
getOrderParameterForSim(simname,trange,datapath,radii,border=True,gzipped=False,outpath=outpath)
