import os,string
import sys
sys.path.append('src/')
from CC3DSimUtils import makeImages,stackImages

# settings
# simname will be used as the basis of filenames data files and the generated images. 
simname = 'longcells_chem'
# name of the chemical field
fieldname = 'morph'
# path where data files are located, e.g. longcells_nochem_CF_0.data
datapath = 'data/'+simname+'/'
# path where images will be stored
# if this path doesn't exist, it will be created
impath = 'images/'+simname+'/'
if not os.path.isdir(impath):
    os.mkdir(impath)
# list of time steps at which the morphology will be drawn
trange = range(0,10001,500)
# file with on each line: celltype r g b
colormap = 'default.ctb'
# scaling factor for the images
scale = 2

# create the image using the function makeImages from SimUtils
makeImages(simname,trange,datapath,impath,cm=colormap,gzipped=False,timestamp=False,scale=scale,fieldname=fieldname,border=True)

# compase image with time steps 500,2000,5000,10000
tlist = [500,2000,5000,10000]
tlen = len(str(max(tlist)))
imlist = dict((string.zfill(t,tlen),impath+simname+'_'+string.zfill(t,tlen)+'.png') for t in tlist)
stackImages(imlist,[4,1],'results/'+simname+'.png',label=True,fontsize=110)
