import sys
sys.path.append('src/')
from CC3DSimUtils import getCompactnessForSim

# simname will be used as the basis of filenames data files and the generated images. 
simname = 'longcells_chem'
# path where data files are located, e.g. longcells_nochem_CF_0.data
datapath = 'data/'+simname+'/'
# path where results will be stored
outpath = 'results/'
# list of time steps for which the compactness will be calculated
# we skip the first time step because at that time step the cells are dispersed
# and the algorithm will just calculate the compactness of a single cell
trange = range(50,10001,50)

# calculate compactness using getCompactnessForSim in SimUtils
getCompactnessForSim(simname,trange,datapath,outpath=outpath,gzipped=False,border=True)
