import string,time
import sys
sys.path.append('src/')
from CC3DSimUtils import readSigma,getRelativeDirField,drawRelDirField,stackImages

# simname will be used as the basis of filenames data files and the generated images. 
simname = 'longcells_chem'
# path where data files are located, e.g. longcells_nochem_CF_0.data
datapath = 'data/'+simname+'/'
# path where images with relative director are stored
impath = 'images/'+simname+'/'
if not os.path.isdir(impath):
    os.mkdir(impath)
outpath = 'results/'
# list of time steps for which the relative director will be calculated
tlist = [500,2000,5000,10000]
# radius for which the relative director will be calculated
r = 3

# create image of the relative director for each time step in tlist
images = {}
t0 = time.time()
for i,t in enumerate(tlist):
    # load cell types
    sigma = readSigma(simname,t,datapath,gzipped=False,border=True)
    # calculate relative director field
    field = getRelativeDirField(sigma,r)
    # draw relative director field
    im = drawRelDirField(field,sigma,scale=2)
    imname = impath+'/'+simname+'_reldir_r='+str(r)+'_'+string.zfill(t,5)+'.png'
    images[string.zfill(t,5)] = imname
    im.save(imname)
print 'calculated and drawn '+str(len(tlist))+' relative director fields in '+str(time.time()-t0)+' seconds'

# create image with all 4 relative director images in one image
stackImages(images,[4,1],'results/'+simname+'_reldir_r='+str(r)+'.png',label=True,fontsize=110)
