import sys,os,math
sys.path.append('src/')
from CC3DSimUtils import makeImages,getCompactnessForSim,getOrderParameterForSim,getClustersForSim

# set paths
projectpath = 'PROJECTPATH'
execpath = 'CC3DPATH'

# select correct executable for cc3d depending on the platform
if sys.platform.startswith('win'):
    executable = 'runScript.bat'
else:
    executable = 'runScript.sh'

# read arguments
args = sys.argv
if len(args) == 1:
    sys.exit('missing argument')
id = args[len(args)-1]

# create data directory if it doesn't exist
if not os.path.isdir(projectpath+'/data/'+id):
    os.mkdir(projectpath+'/data/'+id)

# run cc3d
os.system(execpath+'/'+executable+' --noOutput -i '+projectpath+'/scripts/'+id+'.cc3d')

# create images
if not os.path.isdir(projectpath+'/images/'+id):
    os.mkdir(projectpath+'/images/'+id)
trange = range(0,100001,1000)
makeImages(id,trange,projectpath+'/data/'+id,projectpath+'/images/'+id,cm='default.ctb')

# calculate compactness
trange = range(0,100001,1000)
getCompactnessForSim(id,trange,projectpath+'/data/'+id,gzipped=False,border=True)

# calculate order parameter
radii = [20,40,60]
trange = range(0,100001,250)
getOrderParameterForSim(id,trange,projectpath+'/data/'+id,radii,gzipped=False,border=True)

# calculate clusters
[r,th,minlabsize,opendisk,mincellsize] = [3,5*(math.pi/180),50,1,.5]
trange = range(0,100001,250)
getClustersForSim(id,trange,projectpath+'/data/'+id,r,th,minlabsize,opendisk,mincellsize,gzipped=False,border=True,outpath=projectpath+'/data/'+id)
